/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     22/12/2014
   Fichier :  F2_PCOUL.INO
   Document : Option module Bluetooth pour Portail Coulissant (Réf. D-PCOUL-BLTH)
   Objectif : Piloter l’ouverture et la fermeture du portail coulissant à distance avec un Smartphone
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

A5	(libre)
A4	(libre)
A3	(libre)
A2	(libre)
A1	(libre)
A0	(libre)
 	
13	(libre)
12	Gyrophare
11	Moteur sens Fermeture
10	Moteur sens Ouverture
9	Emetteur infrarouge
8	(libre)
7	Récepteur infrarouge
6	(libre)
5	Bouton-poussoir extérieur
4	Bouton-poussoir intérieur
3	Fin de course portail fermé
2	Fin de course portail ouvert
1	Bluetooth connecteur RX (liaison avec la sortie de données TX)
0	Bluetooth connecteur TX (liaison avec l’entrée de données RX)

------------------------------------------------------------------------------------------------------------------------------
*/


//Définition des variables, constantes et pin :
// Pin d'entrées

const int fdc_fermeture = 3; 
const int fdc_ouverture = 2; 


//Pin de sorties
const int gyrophare = 12; 


//Configuration moteur
const int ouverture = 10; 
const int fermeture = 11; 

int commande_recue;
//Initialisation

void setup()
{
   Serial.begin(9600); 
   
    //paramètrage des pins en entrée/sortie
    
    // Définition des pins comme des entrées

    pinMode (fdc_fermeture, INPUT);
    pinMode (fdc_ouverture, INPUT);
   
    // Définition des pins comme des sorties
    pinMode (gyrophare, OUTPUT);
    pinMode (ouverture, OUTPUT);
    pinMode (fermeture, OUTPUT);

    
    // Etat Initial Moteur
    digitalWrite(ouverture, LOW);  
    digitalWrite(fermeture, LOW); // Il est important que les deux états ne soient jamais tous les deux sur HIGH en même temps
  
}



//Programme principal

//Boucle infinie
void loop()
{

 if (Serial.available() > 0) // Y a-t-il de l'activité sur le port série ? 
 {

  commande_recue = Serial.read();
  
   
  if (commande_recue == 1)  // Rentrer dans la boucle si la commande_recue est "1"
  {  
      
    if (digitalRead(fdc_ouverture)==LOW)
    {
     do
     {
      digitalWrite(ouverture, HIGH); // activation du moteur : sens ouverture
      digitalWrite(gyrophare, HIGH); // allumage du gyrophare 
     }while (digitalRead(fdc_ouverture)==LOW);// rester dans la boucle tant que fdc_ouverture n'est pas activé
             
    digitalWrite(ouverture, LOW);  
    digitalWrite(fermeture, LOW); // arrêt du moteur
    digitalWrite(gyrophare, LOW); // extinction du gyrophare
   } 
    
    
    else
    {
     do   
      {
        digitalWrite(fermeture, HIGH); // activation du moteur : sens fermeture
        digitalWrite(gyrophare, HIGH); // allumage du gyrophare  
      } while (digitalRead(fdc_fermeture)==LOW);// rester dans la boucle tant que fdc_fermeture n'est pas activé
             
    digitalWrite(ouverture, LOW);  
    digitalWrite(fermeture, LOW); // arrêt du moteur
    digitalWrite(gyrophare, LOW); // extinction du gyrophare
    } 
  
  }
  
 }
 
} 
// Fin du Programme principal


